import pygame
import math

def distance (a, b):
    return math.sqrt( (a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1]) )

def mousePressed():
    global startx, starty, down
    if alt:
        startx = mouseX
        starty = mouseY
    elif clone:
        down = True
        s1 = img.subsurface((mouseX-dx-15, mouseY-dy-15, 30, 30))
        s2 = screen.subsurface((mouseX-dx-15, mouseY-dy-15, 30, 30))
#        pygame.image.save(s1, "s1.png")
#       pygame.image.save(s2, "s2.png")
        for i in range(-15,15):
            for j in range(-15,15):
                if math.sqrt(i*i + j*j) < 15:
                    try:
                        c = img.get_at((mouseX-dx+i, mouseY-dy+j))
# -------------------  This appears to be a problem with Pygame - red and blue are reversed.
                        img.set_at((mouseX+i, mouseY+j), (c[2],c[1],c[0]))
                    except:
                        continue


def mouseReleased():
    global dx, dy, clone, down
    if alt:
        dx = mouseX - startx
        dy = mouseY - starty
        clone = True
    down = False

def keyPressed(e):
    global alt
    if (e.key == pygame.K_LALT) or (e.key == pygame.K_RALT):
        alt = True


def keyReleased(e):
    global alt
    alt = False

img = pygame.image.load("test.png")
screen = pygame.display.set_mode((img.get_width(), img.get_height()))  # Notice the tuple! It's not 2 arguments.
clock = pygame.time.Clock()
pygame.init()
FPS = 60  # This variable will define how many frames we update per second.
down = False
alt = False
clone = False
down = False
dx = 0
dy = 0
startx = 0
starty = 0

while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()
        if event.type == pygame.MOUSEBUTTONDOWN or down:
            mousePressed()
        if event.type == pygame.MOUSEBUTTONUP:
            mouseReleased()
        if event.type == pygame.KEYDOWN:
            keyPressed(event)
        if event.type == pygame.KEYUP:
            keyReleased(event)
    screen.blit(img, (0,0))
    if clone:
        pygame.draw.circle (screen, (0,0,0), (mouseX-dx, mouseY-dy), 15, 1)
    pygame.display.update()  # redraw the screen
